﻿Imports System.Net.NetworkInformation
Imports System
Imports System.Net
Imports System.IO
Imports System.Diagnostics
Imports System.Threading

Public Class update

    Dim IP As IPAddress = IPAddress.Parse("144.76.167.70")
    Dim IP2 As IPAddress = IPAddress.Parse("91.216.248.30")
    Dim Timeout As Integer = 1000
    Private WithEvents web As New WebClient()
    Dim versionsabfrage As New INIDatei

    'Download Funktion
    Private Sub DownloadFile(url As String)

        AddHandler web.DownloadFileCompleted, AddressOf Downloadfile_complete
        AddHandler web.DownloadProgressChanged, AddressOf Downloadfile_progress

        web.Proxy = Nothing
        web.DownloadFileAsync(New Uri(url), Application.StartupPath.ToString & "\Umrechner.exe")

    End Sub


 

    Private Sub Downloadfile_complete(sender As Object, e As ComponentModel.AsyncCompletedEventArgs)

        versionsabfrage.Pfad = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) & "\Umrechner\settings.ini"

        Dim path As String = Application.StartupPath & "\Umrechner.exe"
        Dim version As FileVersionInfo = FileVersionInfo.GetVersionInfo(path)
        Dim productVer As String = version.ProductVersion
        Dim today_date As DateTime = DateTime.Now


        versionsabfrage.WertSchreiben("General", "Version", productVer)
        versionsabfrage.WertSchreiben("Updaten", "LastUpdate", today_date.ToString)
        versionsabfrage.WertSchreiben("Updaten", "wert", "ja")


        detailausgabe.AppendText(vbNewLine & "Die aktualisierung ist abgeschlossen.")
        Beep()
        abbrechen.Enabled = True
        startclose.Enabled = True

    End Sub

    Private Sub Downloadfile_progress(sender As Object, e As DownloadProgressChangedEventArgs)

        Me.ProgressBar1.Value = e.ProgressPercentage
        percent.Text = e.ProgressPercentage & "%"
        Dim totalbytes As Double = Math.Round(e.TotalBytesToReceive / 1024)
        Dim bytes As Double = Math.Round(e.BytesReceived / 1024)


        Me.detailausgabe.AppendText(vbNewLine & bytes & "KB von" & totalbytes & "KB")

    End Sub



    'Ping Funktion
    Private Sub StartPing(address As IPAddress)
        If detailausgabe.Text = "" Then
            detailausgabe.AppendText("Verbinde mit Server " & address.ToString & ".....")

        Else
            detailausgabe.AppendText(vbNewLine & "Verbinde mit Server " & address.ToString & ".....")

        End If

        'Ping Anfrage senden
        Dim ping As New Ping()
        AddHandler ping.PingCompleted, AddressOf Ping_Completed
        ping.SendAsync(address, Timeout, Nothing)
    End Sub

   
    Private Sub Ping_Completed(sender As Object, e As PingCompletedEventArgs)
        If e.Error Is Nothing AndAlso e.Reply.Status = IPStatus.Success Then
            detailausgabe.AppendText(vbNewLine & "Antwort in " & e.Reply.RoundtripTime & "ms erhalten.....")

            'Aussehen der Progressbar ändern
            ProgressBar1.Style = ProgressBarStyle.Blocks
            detailausgabe.Focus()

            If e.Reply.Address.ToString = "144.76.167.70" Then
                detailausgabe.AppendText(vbNewLine & "Verbinde mit Downloadserver 1...." & vbNewLine & "Aktualisierung läuft....")
                DownloadFile("http://marvinkleinmusic.bplaced.net/Dezimalrechner/Umrechner.exe")

            ElseIf e.Reply.Address.ToString = "91.216.248.30" Then
                detailausgabe.AppendText(vbNewLine & "Verbinde mit Downloadserver 2...." & vbNewLine & "Aktualisierung läuft....")
                ' DownloadFile("http://download.lima-city.de/marvinkleinmusic/Umrechner.exe")
                DownloadFile("http://marvinkleinmusic.bplaced.net/Dezimalrechner/Umrechner.exe")

            Else
                detailausgabe.AppendText(vbNewLine & "Es konnte kein Server erreicht werden....")

            End If
            'DownloadFile()

        Else
            abbrechen.Enabled = True
            detailausgabe.AppendText(vbNewLine & "Es konnte keine Verbindung zum Server hergestellt werden.....")

            If e.Reply.Address.ToString = "0.0.0.0" Then
                StartPing(IPAddress.Parse("91.216.248.30"))
            Else
                detailausgabe.AppendText(vbNewLine & "Es konnte kein Server erreicht werden....")
            End If

        End If
    End Sub


    'Load event
    Private Sub update_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        'Alle Umrechner Prozesse beenden
        For Each Process In System.Diagnostics.Process.GetProcessesByName("Umrechner")
            Process.Kill()
        Next
        percent.Text = Nothing

        Me.Show()

        'Überprüfung ob Ordner Umrechner in AppData vorhanden ist
        If System.IO.Directory.Exists(Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) & "\Umrechner") = False Then

            'Ordner in AppData erstellen
            System.IO.Directory.CreateDirectory(Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) & "\Umrechner")


            versionsabfrage.Pfad = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) & "\Umrechner"

            'Abfrage ob die settings Datei des Umrechners existiert
            If File.Exists(Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) & "\Umrechner\settings.ini") Then
                If versionsabfrage.WertLesen("General", "Version") = Nothing Then
                    versionsabfrage.WertSchreiben("General", "Version", "1.0.0")
                End If
            Else
                versionsabfrage.WertSchreiben("General", "Version", "1.0.0")

            End If
        End If

        StartPing(IPAddress.Parse("144.76.167.70"))


        abbrechen.Enabled = False
        startclose.Enabled = False

    End Sub

    'Formular beweglich machen
    Private Sub Form1_MouseDown(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles MyBase.MouseDown
        If (e.Button = Windows.Forms.MouseButtons.Left) Then
            Me.Capture = False
            Me.WndProc(Message.Create(Me.Handle, &HA1, CType(&H2, IntPtr), IntPtr.Zero))

        Else : End If
    End Sub

    'Buttons
    Private Sub abbrechen_Click(sender As System.Object, e As System.EventArgs) Handles abbrechen.Click
        Application.Exit()
    End Sub

    Private Sub startclose_Click(sender As System.Object, e As System.EventArgs) Handles startclose.Click
        Process.Start(Application.StartupPath & "\Umrechner.exe")
        Application.Exit()
    End Sub
End Class

